import axios from "axios";
import type { Categories, PaginatedCategories } from "./interfaces/categories.interface";

export const useResourcesStore = defineStore("resources_store", () => {
    const runtimeConfig = useRuntimeConfig();
    const categories = ref<Categories[]>([]);
    const total_categoríes = ref<number>(0);

    const getCategories = async (): Promise<PaginatedCategories> => {
        try {
            const categories = await axios.get<PaginatedCategories>(`${runtimeConfig.public.api_url}/api/categories?limit=5`);

            if (categories.data) {
                return categories.data;
            } else {
                return {
                    categories: [],
                    total: 0,
                    limit: 5,
                    page: 1
                };
            }

        } catch (error) {
            console.log(error, ' error');
            return {
                categories: [],
                total: 0,
                limit: 5,
                page: 1
            };
        }
    }

    return {
        getCategories,

        categories,
        total_categoríes,
    }
})