import axios, { AxiosError } from "axios";
import type { RegisterInterface } from "./interfaces/register.interface"
import type { GenericResponseInterface } from "@/pinia/interfaces/generic_response.interfae";

export const useRegisterStore = defineStore("register_store", () => {

    const runtimeConfig = useRuntimeConfig();
    const user_created = ref<boolean>(false);

    /**
     * Retorna si el usuario fue creado con éxito o no
     * @param data 
     * @returns 
     */
    const register = async (data: RegisterInterface): Promise<boolean> => {
        try {

            const created = await axios.post<GenericResponseInterface>(`${runtimeConfig.public.api_url}/api/auth/register`, data);

            if (created.data) {
                return true;
            } else {
                return false;
            }
        } catch (error) {
            return false;
        }
    }

    /**
     * Activa la cuenta del dicho usuario mediante un token.
     * @param token 
     * @returns 
     */
    const activateAccount = async (token: string): Promise<{status: boolean, msg: string}> => {
        try {
            const activate_account = await axios.get<GenericResponseInterface>(`${runtimeConfig.public.api_url}/api/auth/activate_account/${token}`);

            if (activate_account.data) {
                return { status: true, msg: 'Cuenta verificada correctamente.' };
            } else {
                return { status: false, msg: 'Hubo un error al activar la cuenta.' }
            }
        } catch (error) {
            if (error instanceof AxiosError) {
                if(error.response?.data.message) {
                    return { status: false, msg: error.response?.data.message };
                } else {
                    return { status: false, msg: 'Hubo un error al activar la cuenta.' };
                }
            } else {
                return { status: false, msg: 'Hubo un error al activar la cuenta.' }
            }
        }
    }

    /**
     * Reenvia email de activación de la cuenta.
     * @param token 
     * @returns 
     */
    const sendEmailVerification = async (token: string): Promise<boolean> => {
        try {
            const sent = await axios.get<GenericResponseInterface>(`${runtimeConfig.public.api_url}/api/auth/send_email_activation/${token}`);
            
            if(sent.data) {
                return true;
            } else {
                return false;
            }
        } catch (error: unknown) {
            return false;
        }
    }


    return {
        register,
        activateAccount,
        sendEmailVerification,

        user_created,
    }
})