// https://nuxt.com/docs/api/configuration/nuxt-config
export default defineNuxtConfig({
  devtools: { enabled: false },
  ssr: true,
  devServer: {
    port: 40000,
  },
  vite: {
    css: {
      preprocessorOptions: {
        scss: {
          quietDeps: true,
          additionalData: '@use "sass:math";'
        }
      }
    }
  },
  modules: [
    [
      '@pinia/nuxt',
      {
        autoImports: [
          'defineStore',
          ['defineStore', 'definePiniaStore'],
        ],
      },
    ],
  ],
  app: {
    head: {
      title: "VectorGeenk - La mejor tienda de vectores",
      meta: [
        { charset: 'utf-8' },
        { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      ],
      charset: 'utf-8',
      viewport: 'width=device-width, initial-scale=1',
      script: [
        // {
        //   src: "https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.bundle.min.js",
        // },
      ],
    }
  },
  css: [
    "bootstrap/dist/css/bootstrap.min.css",
    "swiper/css/bundle",
    "@/assets/css/font-awesome-pro.css",
    "@/assets/css/flaticon_shofy.css",
    "@/assets/scss/main.scss",
  ],
  runtimeConfig: {
    public: {
      api_url: process.env.API_URL,
      cookies_domain: process.env.COOKIES_DOMAIN,
      stripe_public_key: process.env.STRIPE_PUBLIC_KEY
    }
  }
})
