import { type IProduct } from "@/types/product-type";

const product_data: IProduct[] = [
  {
    id: "641e887d05f9ee1717e1348a",
    sku: "NTB7SDVX44",
    img: "https://i.ibb.co/WVdTgR8/headphone-1.png",
    title: "Headphones Wireless.",
    slug: "headphones-wireless.",
    unit: "3pcs",
    imageURLs: [
      {
        color: {
          name: "Purply Blue",
          clrCode: "#C1BAE4",
        },
        img: "https://i.ibb.co/WVdTgR8/headphone-1.png",
      },
      {
        color: {
          name: "Light Grey",
          clrCode: "#D8D7DD",
        },
        img: "https://i.ibb.co/zh9x3Q0/headphone-2.png",
      },
      {
        color: {
          name: "Baby Pink",
          clrCode: "#F3C0D1",
        },
        img: "https://i.ibb.co/JBZk7sS/headphone-3.png",
      },
      {
        color: {
          name: "Bluish Cyan",
          clrCode: "#64BFD1",
        },
        img: "https://i.ibb.co/SrPq3r0/headphone-4.png",
      },
    ],
    parent: "Headphones",
    children: "Bluetooth Headphones",
    price: 120,
    discount: 14,
    quantity: 12,
    brand: {
      name: "Logitech",
    },
    category: {
      name: "Headphones",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "09 March, 2023",
        name: "Mark Smith",
        email: "mark@gmail.com",
        rating: 1,
      },
    ],
    productType: "electronics",
    description:
      "Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering. With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow. We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish. The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class. Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known. It complies with Microsoft's Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode.",
    additionalInformation: [
      {
        key: "Standing screen display size",
        value: "Screen display Size 10.4",
      },
      {
        key: "Colors",
        value: "Purply Blue, Light Grey, Baby Pink, Bluish Cyan",
      },
      {
        key: "Screen Resolution",
        value: "1920 x 1200 Pixels",
      },
      {
        key: "Max Screen Resolution",
        value: "2000 x 1200",
      },
      {
        key: "Processor",
        value: "2.3 GHz (128 GB)",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 1,
    tags: ["Headphones", "Bluetooth "],
  },
  {
    id: "641e887d05f9ee1717e1348f",
    sku: "NVB7SDVX45",
    img: "https://i.ibb.co/n1YRvWJ/headphone-5.png",
    title: "Gaming Headphone",
    slug: "gaming-headphone",
    unit: "5pcs",
    imageURLs: [
      {
        color: {
          name: "Cyan",
          clrCode: "#03E2DD",
        },
        img: "https://i.ibb.co/n1YRvWJ/headphone-5.png",
      },
      {
        color: {
          name: "Dark Grey",
          clrCode: "#484848",
        },
        img: "https://i.ibb.co/WpkH1vq/headphone-6.png",
      },
      {
        color: {
          name: "Orange",
          clrCode: "#F17B3D",
        },
        img: "https://i.ibb.co/yRYbDCc/headphone-7.png",
      },
    ],
    parent: "Headphones",
    children: "Kids Headphones",
    price: 130,
    discount: 5,
    quantity: 10,
    brand: {
      name: "Sony",
    },
    category: {
      name: "Headphones",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering. With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow. We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish. The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class. Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known. It complies with Microsoft's Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode.",
    additionalInformation: [
      {
        key: "Standing screen display size",
        value: "Screen display Size 10.4",
      },
      {
        key: "Colors",
        value: "Cyan, Dark Grey, Orange",
      },
      {
        key: "Screen Resolution",
        value: "1920 x 1200 Pixels",
      },
      {
        key: "Max Screen Resolution",
        value: "2000 x 1200",
      },
      {
        key: "Processor",
        value: "2.3 GHz (128 GB)",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    offerDate: {
      startDate: "2023-08-15T18:00:00.000Z",
      endDate: "2024-07-19T18:00:00.000Z",
    },
    featured: false,
    sellCount: 2,
    tags: ["Headphones", "Kids "],
  },
  {
    id: "641e887d05f9ee1717e13496",
    sku: "BVB7SDVX50",
    img: "https://i.ibb.co/5FPhGtq/headphone-8.png",
    title: "Headphone with Mic",
    slug: "headphone-with-mic",
    unit: "4pcs",
    imageURLs: [
      {
        color: {
          name: "Tealish Blue",
          clrCode: "#455D89",
        },
        img: "https://i.ibb.co/5FPhGtq/headphone-8.png",
      },
      {
        color: {
          name: "Silver",
          clrCode: "#ECECEC",
        },
        img: "https://i.ibb.co/vHP1TQf/headphone-9.png",
      },
      {
        color: {
          name: "Reddish Magenta",
          clrCode: "#DED3DB",
        },
        img: "https://i.ibb.co/3mdtrcm/headphone-10.png",
      },
    ],
    parent: "Headphones",
    children: "On-Ear Headphones",
    price: 110,
    discount: 0,
    quantity: 8,
    brand: {
      name: "Sony",
    },
    category: {
      name: "Headphones",
    },
    status: "out-of-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 4,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "10 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 2,
      },
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 3.5,
      },
    ],
    productType: "electronics",
    description:
      "Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering. With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow. We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish. The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class. Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known. It complies with Microsoft's Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode.",
    additionalInformation: [
      {
        key: "Standing screen display size",
        value: "Screen display Size 10.4",
      },
      {
        key: "Colors",
        value: "Tealish Blue, Silver, Reddish Magenta",
      },
      {
        key: "Screen Resolution",
        value: "1920 x 1200 Pixels",
      },
      {
        key: "Max Screen Resolution",
        value: "2000 x 1200",
      },
      {
        key: "Processor",
        value: "2.3 GHz (128 GB)",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: true,
    sellCount: 0,
    tags: ["Headphones", "On-Ear"],
    videoId: "EW4ZYb3mCZk",
  },
  {
    id: "641e887d05f9ee1717e1349a",
    sku: "BD7SDVX62",
    img: "https://i.ibb.co/jvGv6qf/mobile-1.png",
    title: "Galaxy Android Tablet",
    slug: "galaxy-android-tablet",
    unit: "8pcs",
    imageURLs: [
      {
        color: {
          name: "Black",
          clrCode: "#3A454B",
        },
        img: "https://i.ibb.co/jvGv6qf/mobile-1.png",
      },
      {
        color: {
          name: "Gray",
          clrCode: "#3C3B39",
        },
        img: "https://i.ibb.co/F3VPLLh/mobile-2.png",
      },
      {
        color: {
          name: "Silver",
          clrCode: "#343338",
        },
        img: "https://i.ibb.co/rtmKcPg/mobile-3.png",
      },
      {
        color: {
          name: "Cadet Grey",
          clrCode: "#7B97A3",
        },
        img: "https://i.ibb.co/NpWtdts/mobile-4.png",
      },
    ],
    parent: "Mobile Tablets",
    children: "Samsung",
    price: 320,
    discount: 10,
    quantity: 12,
    brand: {
      name: "Samsung",
    },
    category: {
      name: "Mobile Tablets",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 4.5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 3,
      },
    ],
    productType: "electronics",
    description:
      "Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering. With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow. We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish. The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class. Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known. It complies with Microsoft's Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2022, September",
      },
      {
        key: "Colors",
        value: "Black, Gray, Silver, Cadet Grey",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["Mobile ", "Tablets", "Samsung"],
  },
  {
    id: "641e887d05f9ee1717e1349f",
    sku: "AF7SDVX65",
    img: "https://i.ibb.co/3WMPkkf/mobile-5.png",
    title: "iPhone 14 Pro",
    slug: "iPhone-14-pro",
    unit: "10pcs",
    imageURLs: [
      {
        color: {
          name: "Lunar Green",
          clrCode: "#33422B",
        },
        img: "https://i.ibb.co/3WMPkkf/mobile-5.png",
      },
      {
        color: {
          name: "Dark",
          clrCode: "#292C31",
        },
        img: "https://i.ibb.co/MfdxWfv/mobile-6.png",
      },
      {
        color: {
          name: "Red Wine",
          clrCode: "#BA1827",
        },
        img: "https://i.ibb.co/vV22rXc/mobile-7.png",
      },
      {
        color: {
          name: "Peach Schnapps",
          clrCode: "#EAD2CE",
        },
        img: "https://i.ibb.co/Kby3sY7/mobile-8.png",
      },
    ],
    parent: "Mobile Tablets",
    children: "Apple",
    price: 1199,
    discount: 15,
    quantity: 20,
    brand: {
      name: "Apple",
    },
    category: {
      name: "Mobile Tablets",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 4.5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering. With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow. We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish. The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class. Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known. It complies with Microsoft's Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Lunar Green, Dark, Red Wine, Peach Schnapps",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: true,
    sellCount: 0,
    tags: ["Mobile ", "Tablets", "Apple"],
  },
  {
    id: "641d4106dbfab7b02ab28b22",
    sku: "CF7SDVX72",
    img: "https://i.ibb.co/kxGMcrw/ipad-1.png",
    title: "Apple iPad Air",
    slug: "apple-iPad-air",
    unit: "12pcs",
    imageURLs: [
      {
        color: {
          name: "Gray",
          clrCode: "#D1CFE4",
        },
        img: "https://i.ibb.co/kxGMcrw/ipad-1.png",
      },
      {
        color: {
          name: "Black",
          clrCode: "#929095",
        },
        img: "https://i.ibb.co/NpWzRPL/ipad-2.png",
      },
      {
        color: {
          name: "Moonstone Blue",
          clrCode: "#9DC1D1",
        },
        img: "https://i.ibb.co/bzgBZ4Y/ipad-3.png",
      },
    ],
    parent: "Mobile Tablets",
    children: "Apple",
    price: 999,
    discount: 5,
    quantity: 13,
    brand: {
      name: "Apple",
    },
    category: {
      name: "Mobile Tablets",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering. With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow. We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish. The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class. Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known. It complies with Microsoft's Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Gray, Black, Moonstone Blue",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: true,
    sellCount: 0,
    tags: ["Mobile ", "Ipad", "Apple"],
  },
  {
    id: "641e887d05f9ee1717e134ad",
    sku: "DF7SDVX72",
    img: "https://i.ibb.co/wYZr4k6/cpu-1.png",
    title: "DeepCool Air Cooler",
    slug: "deepCool-air-cooler",
    unit: "15pcs",
    imageURLs: [
      {
        color: {
          name: "Black",
          clrCode: "#565656",
        },
        img: "https://i.ibb.co/wYZr4k6/cpu-1.png",
      },
      {
        color: {
          name: "Carbon Grey",
          clrCode: "#606060",
        },
        img: "https://i.ibb.co/xsKNnzM/cpu-2.png",
      },
      {
        color: {
          name: "White",
          clrCode: "#F4F4F4",
        },
        img: "https://i.ibb.co/Yf8YRGy/cpu-3.png",
      },
      {
        color: {
          name: "Light Gray",
          clrCode: "#3C3C3C",
        },
        img: "https://i.ibb.co/23XyrR3/cpu-4.png",
      },
    ],
    parent: "CPU Heat Pipes",
    children: "CPU Cooler",
    price: 80,
    discount: 0,
    quantity: 5,
    brand: {
      name: "Deepcool",
    },
    category: {
      name: "CPU Heat Pipes",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "DeepCool ICE EDGE MINI FS V2.0 CPU Air Cooler DeepCool ICE EDGE MINI FS V2.0 CPU Air Cooler is AMD AM4 Ready. (NOTE: Refer to FM2+/ FM2/ FM1/ AM3+/ AM3/ AM2+/ AM2 for the manuals). It is equipped with multiple clips to support Intel LGA1155/ 1156/ 775 and AMD AM4/ AM3/ AM2+/ AM2/ K8. It has 2 sintered metal powder heatpipes directly contacting the CPU surface for removing heat and eliminating chances of overheating. It features specialized aluminum heatsink construction for efficient heat dissipation. TPE fan housing designed to absorb operating vibration and reduce fan noise. it has a 1-year warranty.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Black, Carbon Grey, White, Light Gray",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["cpu", "cpu cooler"],
  },
  {
    id: "641e887d05f9ee1717e134b2",
    sku: "DF7SDVX75",
    img: "https://i.ibb.co/tpypd3B/cpu-5.png",
    title: "Antec Air Cooler",
    slug: "antec-air-cooler",
    unit: "15pcs",
    imageURLs: [
      {
        color: {
          name: "Black",
          clrCode: "#3A3A3A",
        },
        img: "https://i.ibb.co/tpypd3B/cpu-5.png",
      },
      {
        color: {
          name: "Silver",
          clrCode: "#4E534F",
        },
        img: "https://i.ibb.co/wwNDDSG/cpu-6.png",
      },
      {
        color: {
          name: "Gray",
          clrCode: "#0E0E0E",
        },
        img: "https://i.ibb.co/sHRhjSC/cpu-7.png",
      },
      {
        color: {
          name: "Light Gray",
          clrCode: "#7C7C7C",
        },
        img: "https://i.ibb.co/vDrwNFX/cpu-8.png",
      },
    ],
    parent: "CPU Heat Pipes",
    children: "Air CPU Cooler",
    price: 80,
    discount: 0,
    quantity: 5,
    brand: {
      name: "Antec",
    },
    category: {
      name: "CPU Heat Pipes",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "Antec ICE EDGE MINI FS V2.0 CPU Air Cooler DeepCool ICE EDGE MINI FS V2.0 CPU Air Cooler is AMD AM4 Ready. (NOTE: Refer to FM2+/ FM2/ FM1/ AM3+/ AM3/ AM2+/ AM2 for the manuals). It is equipped with multiple clips to support Intel LGA1155/ 1156/ 775 and AMD AM4/ AM3/ AM2+/ AM2/ K8. It has 2 sintered metal powder heatpipes directly contacting the CPU surface for removing heat and eliminating chances of overheating. It features specialized aluminum heatsink construction for efficient heat dissipation. TPE fan housing designed to absorb operating vibration and reduce fan noise. it has a 1-year warranty.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Black, Silver, Gray, Light Gray",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    offerDate: {
      startDate: "2023-09-11T18:00:00.000Z",
      endDate: "2024-05-11T19:00:00.000Z",
    },
    featured: false,
    sellCount: 0,
    tags: ["cpu", "air cooler"],
  },
  {
    id: "641e887d05f9ee1717e134b7",
    sku: "EF7SDVX72",
    img: "https://i.ibb.co/yRRLCc5/watch-1.png",
    title: "Apple Watch Sport Band",
    slug: "apple-watch-sport-band",
    unit: "18pcs",
    imageURLs: [
      {
        color: {
          name: "Light Gray",
          clrCode: "#D9D5D4",
        },
        img: "https://i.ibb.co/yRRLCc5/watch-1.png",
      },
      {
        color: {
          name: "Black",
          clrCode: "#686465",
        },
        img: "https://i.ibb.co/WK6bhWf/watch-2.png",
      },
      {
        color: {
          name: "White",
          clrCode: "#EAEAEA",
        },
        img: "https://i.ibb.co/f2DJvh9/watch-3.png",
      },
      {
        color: {
          name: "Gray",
          clrCode: "#D0C9D0",
        },
        img: "https://i.ibb.co/8rfG5wZ/watch-4.png",
      },
    ],
    parent: "Smart Watch",
    children: "Apple Watch",
    price: 449,
    discount: 5,
    quantity: 5,
    brand: {
      name: "Apple",
    },
    category: {
      name: "Smart Watch",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "Starlight Aluminum Case with Braided Solo Loop The aluminum case is lightweight and made from 100 percent recycled aerospace-grade alloy. The Braided Solo Loop is made from recycled yarn and silicone threads for an ultracomfortable, stretchable design with no clasps or buckles.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Light Gray, Black, Gray",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["watch", "apple"],
    sizes: [],
  },
  {
    id: "641e887d05f9ee1717e134c0",
    sku: "EF7SDVX73",
    img: "https://i.ibb.co/j4sDV3Q/watch-5.png",
    title: "Sony Smart Watch",
    slug: "sony-smart-watch",
    unit: "12pcs",
    imageURLs: [
      {
        color: {
          name: "Grey Goose",
          clrCode: "#E8E3DD",
        },
        img: "https://i.ibb.co/j4sDV3Q/watch-5.png",
      },
      {
        color: {
          name: "Rose Gold",
          clrCode: "#E0C1BC",
        },
        img: "https://i.ibb.co/hDwW5Td/watch-6.png",
      },
      {
        color: {
          name: "Gold",
          clrCode: "#CBAC97",
        },
        img: "https://i.ibb.co/6HFLgPB/watch-7.png",
      },
      {
        color: {
          name: "Black",
          clrCode: "#282828",
        },
        img: "https://i.ibb.co/JxJ0XS4/watch-8.png",
      },
    ],
    parent: "Smart Watch",
    children: "Sports Smart Watch",
    price: 200,
    discount: 5,
    quantity: 5,
    brand: {
      name: "Sony",
    },
    category: {
      name: "Smart Watch",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "Starlight Aluminum Case with Braided Solo Loop The aluminum case is lightweight and made from 100 percent recycled aerospace-grade alloy. The Braided Solo Loop is made from recycled yarn and silicone threads for an ultracomfortable, stretchable design with no clasps or buckles.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Grey Goose, Rose Gold, Gold, Black",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["watch", "sports"],
  },
  {
    id: "641e887d05f9ee1717e134c6",
    sku: "EG8SDVX74",
    img: "https://i.ibb.co/fMhtt2T/watch-9.png",
    title: "Sony Lady Fitness Watch",
    slug: "sony-lady-fitness-watch",
    unit: "10pcs",
    imageURLs: [
      {
        color: {
          name: "Black",
          clrCode: "#333333",
        },
        img: "https://i.ibb.co/fMhtt2T/watch-9.png",
      },
      {
        color: {
          name: "Oyster Pink",
          clrCode: "#F2C4B4",
        },
        img: "https://i.ibb.co/HK6jnjP/watch-10.png",
      },
      {
        color: {
          name: "Dawn Pink",
          clrCode: "#C9AFB0",
        },
        img: "https://i.ibb.co/RNrDzH7/watch-11.png",
      },
      {
        color: {
          name: "Light Gray",
          clrCode: "#1F1F21",
        },
        img: "https://i.ibb.co/HCzgB0m/watch-12.png",
      },
    ],
    parent: "Smart Watch",
    children: "Fitness Smart Watch",
    price: 150,
    discount: 3,
    quantity: 7,
    brand: {
      name: "Sony",
    },
    category: {
      name: "Smart Watch",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 5,
      },
    ],
    productType: "electronics",
    description:
      "Starlight Aluminum Case with Braided Solo Loop The aluminum case is lightweight and made from 100 percent recycled aerospace-grade alloy. The Braided Solo Loop is made from recycled yarn and silicone threads for an ultracomfortable, stretchable design with no clasps or buckles.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Black, Oyster Pink, Dawn Pink, Light Gray",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    offerDate: {
      startDate: "2023-08-24T18:00:00.000Z",
      endDate: "2024-03-15T18:00:00.000Z",
    },
    featured: true,
    sellCount: 0,
    tags: ["watch", "fitness"],
  },
  {
    id: "641e887d05f9ee1717e134cb",
    sku: "DG8SDVX32",
    img: "https://i.ibb.co/RYST3Ym/blutooth-4.png",
    title: "Lenovo Wireless Bluetooth",
    slug: "lenovo-wireless-bluetooth",
    unit: "7pcs",
    imageURLs: [
      {
        color: {
          name: "Red Wine",
          clrCode: "#D94043",
        },
        img: "https://i.ibb.co/RYST3Ym/blutooth-4.png",
      },
      {
        color: {
          name: "Conifer",
          clrCode: "#B4D842",
        },
        img: "https://i.ibb.co/SXSdbjM/blutooth-5.png",
      },
      {
        color: {
          name: "Silver",
          clrCode: "#414141",
        },
        img: "https://i.ibb.co/L12vDxf/blutooth-6.png",
      },
    ],
    parent: "Bluetooth",
    children: "Wireless Bluetooth",
    price: 70,
    discount: 5,
    quantity: 7,
    brand: {
      name: "Lenovo",
    },
    category: {
      name: "Bluetooth",
    },
    status: "in-stock",
    reviews: [],
    productType: "electronics",
    description:
      "Starlight Aluminum Case with Braided Solo Loop The aluminum case is lightweight and made from 100 percent recycled aerospace-grade alloy. The Braided Solo Loop is made from recycled yarn and silicone threads for an ultracomfortable, stretchable design with no clasps or buckles.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Black, Conifer, Silver",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["bluetooth", "wireless "],
  },
  {
    id: "641e887d05f9ee1717e134cf",
    sku: "DF8SDVX33",
    img: "https://i.ibb.co/fvXHr2Y/blutooth-1.png",
    title: "Lenovo Sports Bluetooth",
    slug: "lenovo-sports-bluetooth",
    unit: "7pcs",
    imageURLs: [
      {
        color: {
          name: "Black",
          clrCode: "#31363C",
        },
        img: "https://i.ibb.co/fvXHr2Y/blutooth-1.png",
      },
      {
        color: {
          name: "Yellow",
          clrCode: "#DEDD80",
        },
        img: "https://i.ibb.co/D920WSP/blutooth-2.png",
      },
      {
        color: {
          name: "Light Gray",
          clrCode: "#C2C2C2",
        },
        img: "https://i.ibb.co/Kw36W0G/blutooth-3.png",
      },
    ],
    parent: "Bluetooth",
    children: "Sports Bluetooth",
    price: 70,
    discount: 5,
    quantity: 7,
    brand: {
      name: "Lenovo",
    },
    category: {
      name: "Bluetooth",
    },
    status: "in-stock",
    reviews: [
      {
        user: "/img/users/user-3.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "06 March, 2023",
        name: "John doe",
        email: "john@gmail.com",
        rating: 3,
      },
      {
        user: "/img/users/user-2.jpg",
        review:
          "Designed very similarly to the nearly double priced Galaxy tab S6, with the only removal being.",
        date: "07 March, 2023",
        name: "Smith Doe",
        email: "smith@gmail.com",
        rating: 2,
      },
    ],
    productType: "electronics",
    description:
      "Starlight Aluminum Case with Braided Solo Loop The aluminum case is lightweight and made from 100 percent recycled aerospace-grade alloy. The Braided Solo Loop is made from recycled yarn and silicone threads for an ultracomfortable, stretchable design with no clasps or buckles.",
    additionalInformation: [
      {
        key: "Announced",
        value: "2023, February",
      },
      {
        key: "Colors",
        value: "Black, Yellow, Light Gray",
      },
      {
        key: "Technology",
        value: "GSM / HSPA / LTE",
      },
      {
        key: "3G bands",
        value: "HSDPA 800 / 850 / 900 / 1900 / 2100",
      },
      {
        key: "4G bands",
        value: "1, 2, 3, 4, 5, 7, 8, 19, 20, 28, 38, 40, 41",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    offerDate: {
      startDate: "2023-07-29T18:00:00.000Z",
      endDate: "2024-06-20T18:00:00.000Z",
    },
    featured: false,
    sellCount: 0,
    tags: ["bluetooth", "sports "],
  },
  {
    id: "6421258288fba3e101965dc3",
    sku: "FAB7SDVX44",
    img: "https://i.ibb.co/gg9yCwX/clothing-1.png",
    title: "Whitetails Women's Dress",
    slug: "whitetails-women's-dress",
    unit: "10pcs",
    imageURLs: [
      {
        color: {
          name: "Wine Berry",
          clrCode: "#642832",
        },
        img: "https://i.ibb.co/gg9yCwX/clothing-1.png",
      },
      {
        color: {
          name: "Wine Berry",
          clrCode: "#642832",
        },
        img: "https://i.ibb.co/tZFbTWQ/clothing-2.png",
      },
      {
        color: {
          name: "Dirty Blue",
          clrCode: "#307FA8",
        },
        img: "https://i.ibb.co/1JqwRnb/clothing-3.png",
      },
      {
        color: {
          name: "Dirty Blue",
          clrCode: "#307FA8",
        },
        img: "https://i.ibb.co/ngwgSt2/clothing-4.png",
      },
    ],
    parent: "Clothing",
    children: "Women's",
    price: 80,
    discount: 5,
    quantity: 10,
    brand: {
      name: "Legendary Whitetails",
    },
    category: {
      name: "Clothing",
    },
    status: "in-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 1,
    tags: ["whitetails", "Clothing", "Women's"],
    sizes: [],
  },
  {
    id: "64215fb702240f90b1138e14",
    sku: "FBB7SDVX45",
    img: "https://i.ibb.co/xXHLYZr/clothing-5.png",
    title: "Boys Graphic T-Shirt",
    slug: "boys-graphic-t-shirt",
    unit: "12pcs",
    imageURLs: [
      {
        color: {
          name: "Terra Cotta",
          clrCode: "#E47561",
        },
        img: "https://i.ibb.co/xXHLYZr/clothing-5.png",
      },
      {
        color: {
          name: "Rodeo Dust",
          clrCode: "#CDB297",
        },
        img: "https://i.ibb.co/JqDrC9g/clothing-6.png",
      },
      {
        color: {
          name: "Camo Green",
          clrCode: "#505F33",
        },
        img: "https://i.ibb.co/3cFJrkR/clothing-7.png",
      },
      {
        color: {
          name: "Rose",
          clrCode: "#ECADA8",
        },
        img: "https://i.ibb.co/yf4LB8p/clothing-8.png",
      },
    ],
    parent: "Clothing",
    children: "Men's",
    price: 65,
    discount: 0,
    quantity: 15,
    brand: {
      name: "Legendary Whitetails",
    },
    category: {
      name: "Clothing",
    },
    status: "out-of-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: true,
    sellCount: 1,
    tags: ["t-shirt", "clothing"],
  },
  {
    id: "6421650a02240f90b1138e1e",
    sku: "FCB7SDVX46",
    img: "https://i.ibb.co/DKJr0w4/clothing-9.png",
    title: "Milumia Blouse",
    slug: "milumia-blouse",
    unit: "17pcs",
    imageURLs: [
      {
        color: {
          name: "Cocoa Bean",
          clrCode: "#4F1523",
        },
        img: "https://i.ibb.co/DKJr0w4/clothing-9.png",
      },
      {
        color: {
          name: "Nile Blue",
          clrCode: "#153E54",
        },
        img: "https://i.ibb.co/SP3Q7b6/clothing-10.png",
      },
      {
        color: {
          name: "Brandy Rose",
          clrCode: "#CB877E",
        },
        img: "https://i.ibb.co/DV3T9Cq/clothing-11.png",
      },
      {
        color: {
          name: "Dark",
          clrCode: "#1B1C31",
        },
        img: "https://i.ibb.co/P9qdSXC/clothing-12.png",
      },
    ],
    parent: "Clothing",
    children: "Women's",
    price: 70,
    discount: 5,
    quantity: 15,
    brand: {
      name: "Legendary Whitetails",
    },
    category: {
      name: "Clothing",
    },
    status: "in-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: true,
    sellCount: 0,
    tags: ["milumia", "blouse"],
    sizes: [],
  },
  {
    id: "642168b402240f90b1138e86",
    sku: "ECB7SDVX56",
    img: "https://i.ibb.co/GvXjssF/bag-1.png",
    title: "Tall Easy Tote-2",
    slug: "tall-easy-tote-2",
    unit: "5pcs",
    imageURLs: [
      {
        color: {
          name: "Donkey Brown",
          clrCode: "#A09370",
        },
        img: "https://i.ibb.co/GvXjssF/bag-1.png",
      },
      {
        color: {
          name: "Pale Carmine",
          clrCode: "#AC3A30",
        },
        img: "https://i.ibb.co/pXXYwgF/bag-2.png",
      },
      {
        color: {
          name: "Spicy Mix",
          clrCode: "#8B543F",
        },
        img: "https://i.ibb.co/ypc0tn9/bag-3.png",
      },
      {
        color: {
          name: "Black Eel",
          clrCode: "#49443E",
        },
        img: "https://i.ibb.co/GxKRg51/bag-4.png",
      },
    ],
    parent: "Bags",
    children: "HandBag",
    price: 110,
    discount: 0,
    quantity: 8,
    brand: {
      name: "Sony",
    },
    category: {
      name: "Bags",
    },
    status: "in-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["sony", "handBag"],
  },
  {
    id: "64216b0902240f90b1138e8e",
    sku: "ECB7SDVX62",
    img: "https://i.ibb.co/zrdMnPd/bag-5.png",
    title: "Traveling Bag",
    slug: "traveling-bag",
    unit: "5pcs",
    imageURLs: [
      {
        color: {
          name: "Clay",
          clrCode: "#B36C58",
        },
        img: "https://i.ibb.co/zrdMnPd/bag-5.png",
      },
      {
        color: {
          name: "English Walnut",
          clrCode: "#402826",
        },
        img: "https://i.ibb.co/ts8dj9z/bag-6.png",
      },
      {
        color: {
          name: "Black",
          clrCode: "#000000",
        },
        img: "https://i.ibb.co/9gY1SrG/bag-7.png",
      },
      {
        color: {
          name: "Ferra",
          clrCode: "#725452",
        },
        img: "https://i.ibb.co/BcDb57T/bag-8.png",
      },
    ],
    parent: "Bags",
    children: "Traveling Bag",
    price: 120,
    discount: 5,
    quantity: 10,
    brand: {
      name: "Sony",
    },
    category: {
      name: "Bags",
    },
    status: "in-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: true,
    sellCount: 0,
    tags: ["traveling", "sony"],
    sizes: [],
  },
  {
    id: "64216e2f02240f90b1138e96",
    sku: "DCB7SDVX64",
    img: "https://i.ibb.co/xgPThxC/shoes-1.png",
    title: "Nike Retro GTS-2",
    slug: "nike-retro-gts-2",
    unit: "4pcs",
    imageURLs: [
      {
        color: {
          name: "Merlot",
          clrCode: "#8E1125",
        },
        img: "https://i.ibb.co/xgPThxC/shoes-1.png",
      },
      {
        color: {
          name: "Gulf Stream",
          clrCode: "#87B0B8",
        },
        img: "https://i.ibb.co/YXbFH8P/shoes-2.png",
      },
      {
        color: {
          name: "Brick Red",
          clrCode: "#BD2B3D",
        },
        img: "https://i.ibb.co/zXHVJLj/shoes-3.png",
      },
      {
        color: {
          name: "Gainsboro",
          clrCode: "#DBDADF",
        },
        img: "https://i.ibb.co/ZxHVh8L/shoes-4.png",
      },
    ],
    parent: "Shoes",
    children: "Men's",
    price: 250,
    discount: 5,
    quantity: 18,
    brand: {
      name: "Nike",
    },
    category: {
      name: "Shoes",
    },
    status: "in-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["nike", "shoes"],
  },
  {
    id: "6421700802240f90b1138e9e",
    sku: "GCB7SDVX72",
    img: "https://i.ibb.co/SQY6zdb/shoes-5.png",
    title: "Jefferson Star Wars™",
    slug: "jefferson-star-wars™",
    unit: "4pcs",
    imageURLs: [
      {
        color: {
          name: "Mustard Green",
          clrCode: "#A7B304",
        },
        img: "https://i.ibb.co/SQY6zdb/shoes-5.png",
      },
      {
        color: {
          name: "Vista White",
          clrCode: "#FCF8F5",
        },
        img: "https://i.ibb.co/VWcTW2t/shoes-6.png",
      },
      {
        color: {
          name: "Chalky",
          clrCode: "#E9D69B",
        },
        img: "https://i.ibb.co/BcJPyh6/shoes-7.png",
      },
      {
        color: {
          name: "Liver",
          clrCode: "#4C5054",
        },
        img: "https://i.ibb.co/PThjLJh/shoes-8.png",
      },
    ],
    parent: "Shoes",
    children: "Women's",
    price: 270,
    discount: 7,
    quantity: 18,
    brand: {
      name: "Nike",
    },
    category: {
      name: "Shoes",
    },
    status: "in-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    featured: false,
    sellCount: 0,
    tags: ["shoes", "jefferson"],
    sizes: [],
  },
  {
    id: "64228862253d81bc860d2092",
    sku: "FCB7SDVX55",
    img: "https://i.ibb.co/ThxGY6N/clothing-13.png",
    title: "Baby Cotton Bodysuits",
    slug: "baby-cotton-bodysuits",
    unit: "12pcs",
    imageURLs: [
      {
        color: {
          name: "Cool Grey",
          clrCode: "#94A2A2",
        },
        img: "https://i.ibb.co/ThxGY6N/clothing-13.png",
      },
      {
        color: {
          name: "Sandstone",
          clrCode: "#7A685E",
        },
        img: "https://i.ibb.co/dJfjNcJ/clothing-14.png",
      },
      {
        color: {
          name: "Soft Amber",
          clrCode: "#DBC8B1",
        },
        img: "https://i.ibb.co/2Yf7bqs/clothing-15.png",
      },
      {
        color: {
          name: "Natural Grey",
          clrCode: "#878881",
        },
        img: "https://i.ibb.co/zf49GS3/clothing-16.png",
      },
    ],
    parent: "Clothing",
    children: "Baby",
    price: 50,
    discount: 0,
    quantity: 15,
    brand: {
      name: "Legendary Whitetails",
    },
    category: {
      name: "Clothing",
    },
    status: "in-stock",
    reviews: [],
    productType: "fashion",
    description:
      "PLENTY OF STORAGE: There are two chest pockets on this women's hooded flannel, making it easy to bring all your favorite things with you. VERSATILE: The Lumber Jane Hooded Flannel is a heavyweight shirt that you can wear open or snapped, depending on your mood. With it's jersey lined hood, it's as warm and comfortable as your favorite hoodie! RELAXED FIT: The women's hooded flannel was made with a relaxed fit for the days you want some room for layering or just want that extra bit of comfort. 100% SATISFACTION GUARANTEE: Designed in the USA, Legendary Whitetails is an American small business. We take pride in all our products. Love it or send it back!",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["Whitetails", "Baby", "Clothing"],
    featured: true,
    sellCount: 2,
  },
  {
    id: "64250d8e253d81bc860d4d26",
    sku: "DCB7SDVX60",
    img: "https://i.ibb.co/qNn6Pqy/powder-1.png",
    title: "INIKA Mineral Sunkissed",
    slug: "inika-mineral-sunkissed",
    unit: "15pcs",
    imageURLs: [
      {
        color: {
          name: "Purple Brown",
          clrCode: "#664536",
        },
        img: "https://i.ibb.co/qNn6Pqy/powder-1.png",
      },
      {
        color: {
          name: "Potters Clay",
          clrCode: "#8B5A39",
        },
        img: "https://i.ibb.co/4RJLN3h/powder-2.png",
      },
      {
        color: {
          name: "Antique Brass",
          clrCode: "#BF8A63",
        },
        img: "https://i.ibb.co/8PV5cC4/powder-3.png",
      },
      {
        color: {
          name: "Pale Taupe",
          clrCode: "#BD9B76",
        },
        img: "https://i.ibb.co/zJ9SWcP/powder-4.png",
      },
    ],
    parent: "Discover Skincare",
    children: "Face Powder",
    price: 85,
    discount: 5,
    quantity: 15,
    brand: {
      name: "INIKA",
    },
    category: {
      name: "Discover Skincare",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["inika", "sunkissed"],
    featured: true,
    sellCount: 4,
    sizes: [],
  },
  {
    id: "642515c0253d81bc860d4da3",
    sku: "DEB7SDVX62",
    img: "https://i.ibb.co/whwFFGX/lip-liner-1.png",
    title: "Grand Plumping Highlighter",
    slug: "grand-plumping-highlighter",
    unit: "10pcs",
    imageURLs: [
      {
        color: {
          name: "Burning Sand",
          clrCode: "#D18F7C",
        },
        img: "https://i.ibb.co/whwFFGX/lip-liner-1.png",
      },
      {
        color: {
          name: "Antique Brass",
          clrCode: "#C88B6A",
        },
        img: "https://i.ibb.co/h9PYFHJ/lip-liner-2.png",
      },
      {
        color: {
          name: "Pinkish Tan",
          clrCode: "#D1A08F",
        },
        img: "https://i.ibb.co/LYr2Nkp/lip-liner-3.png",
      },
    ],
    parent: "Beauty of Skin",
    children: "Lip Liner",
    price: 60,
    discount: 5,
    quantity: 15,
    brand: {
      name: "INIKA",
    },
    category: {
      name: "Beauty of Skin",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["beauty of skin", "lip liner"],
    featured: false,
    sellCount: 3,
  },
  {
    id: "64251bc0253d81bc860d4db5",
    sku: "DFB7SDVX62",
    img: "https://i.ibb.co/vmJzZk4/cosmetics-1.png",
    title: "Brand Cosmetic Product",
    slug: "brand-cosmetic-product",
    unit: "12pcs",
    imageURLs: [
      {
        color: {
          name: "Barney",
          clrCode: "#BF1EB2",
        },
        img: "https://i.ibb.co/vmJzZk4/cosmetics-1.png",
      },
      {
        color: {
          name: "Yellow Ochre",
          clrCode: "#C99E01",
        },
        img: "https://i.ibb.co/kG1N7m8/cosmetics-2.png",
      },
      {
        color: {
          name: "Rich Electric Blue",
          clrCode: "#0393C9",
        },
        img: "https://i.ibb.co/GTJ77k0/cosmetics-3.png",
      },
    ],
    parent: "Awesome Lip Care",
    children: "Cosmetics",
    price: 70,
    discount: 3,
    quantity: 8,
    brand: {
      name: "INIKA",
    },
    category: {
      name: "Awesome Lip Care",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["awesome lip care", "cosmetics"],
    featured: true,
    sellCount: 1,
    sizes: [],
  },
  {
    id: "64252172253d81bc860d4dbe",
    sku: "DGB7SDVX62",
    img: "https://i.ibb.co/p06Mk0H/makeup-1.png",
    title: "Wet Dewy Cream Beige",
    slug: "wet-dewy-cream-beige",
    unit: "12pcs",
    imageURLs: [
      {
        color: {
          name: "Lion",
          clrCode: "#BE9770",
        },
        img: "https://i.ibb.co/p06Mk0H/makeup-1.png",
      },
      {
        color: {
          name: "Pickled Bean",
          clrCode: "#654631",
        },
        img: "https://i.ibb.co/9ttBnfM/makeup-2.png",
      },
      {
        color: {
          name: "Tumbleweed",
          clrCode: "#D4A987",
        },
        img: "https://i.ibb.co/sbpNm8n/makeup-3.png",
      },
      {
        color: {
          name: "Bullet Shell",
          clrCode: "#BC955E",
        },
        img: "https://i.ibb.co/M5z3jP1/makeup-4.png",
      },
    ],
    parent: "Facial Care",
    children: "Makeup Brush",
    price: 90,
    discount: 5,
    quantity: 6,
    brand: {
      name: "INIKA",
    },
    category: {
      name: "Facial Care",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["facial care", "makeup brush"],
    featured: false,
    sellCount: 1,
  },
  {
    id: "6426a68a253d81bc860d5ea6",
    sku: "EGB7SDVX68",
    img: "https://i.ibb.co/mvRsPK5/cosmetics-4.png",
    title: "Tea Tree Lemon For Fine Hair",
    slug: "tea-tree-lemon-for-fine-hair",
    unit: "100ml",
    imageURLs: [
      {
        color: {
          name: "Rangoon Green",
          clrCode: "#142014",
        },
        img: "https://i.ibb.co/mvRsPK5/cosmetics-4.png",
      },
      {
        color: {
          name: "Rangoon Green",
          clrCode: "#142014",
        },
        img: "https://i.ibb.co/rkk6dXX/cosmetics-5.png",
      },
      {
        color: {
          name: "Rangoon Green",
          clrCode: "#142014",
        },
        img: "https://i.ibb.co/TMJPG3B/cosmetics-6.png",
      },
    ],
    parent: "Discover Skincare",
    children: "Makeup Brush",
    price: 45,
    discount: 0,
    quantity: 8,
    brand: {
      name: "INIKA",
    },
    category: {
      name: "Discover Skincare",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["discover skincare", "makeup brush"],
    featured: false,
    sellCount: 0,
  },
  {
    id: "6426ab33253d81bc860d5f86",
    sku: "FGB7SDVX68",
    img: "https://i.ibb.co/bdKTWYy/skin-1.png",
    title: "Mielle Rosemary Mint Scalp",
    slug: "mielle-rosemary-mint-scalp",
    unit: "200ml",
    imageURLs: [
      {
        color: {
          name: "Iridium",
          clrCode: "#3C3C3D",
        },
        img: "https://i.ibb.co/bdKTWYy/skin-1.png",
      },
      {
        color: {
          name: "Iridium",
          clrCode: "#3C3C3D",
        },
        img: "https://i.ibb.co/1GtZ2qC/skin-2.png",
      },
      {
        color: {
          name: "Iridium",
          clrCode: "#3C3C3D",
        },
        img: "https://i.ibb.co/qN95THF/skin-3.png",
      },
    ],
    parent: "Beauty of Skin",
    children: "Skin",
    price: 62,
    discount: 4,
    quantity: 10,
    brand: {
      name: "Antec",
    },
    category: {
      name: "Beauty of Skin",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["beauty of skin", "skin"],
    featured: false,
    sellCount: 2,
  },
  {
    id: "6426adba253d81bc860d6132",
    sku: "FCB7SDVX68",
    img: "https://i.ibb.co/T04BRtd/cream-1.png",
    title: "Innisfree Face Wash",
    slug: "innisfree face wash",
    unit: "150ml",
    imageURLs: [
      {
        color: {
          name: "Faded Green",
          clrCode: "#80AF6B",
        },
        img: "https://i.ibb.co/T04BRtd/cream-1.png",
      },
      {
        color: {
          name: "Summer Green",
          clrCode: "#A6B7A5",
        },
        img: "https://i.ibb.co/8YGVKhd/cream-2.png",
      },
      {
        color: {
          name: "Dark Green",
          clrCode: "#1A2419",
        },
        img: "https://i.ibb.co/D1Hw4f4/cream-3.png",
      },
    ],
    parent: "Awesome Lip Care",
    children: "Cream",
    price: 68,
    discount: 3,
    quantity: 12,
    brand: {
      name: "INIKA",
    },
    category: {
      name: "Awesome Lip Care",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["awesome lip care", "cream"],
    featured: false,
    sellCount: 5,
  },
  {
    id: "6426b217253d81bc860d6217",
    sku: "FEB7SDVX68",
    img: "https://i.ibb.co/XsZ9vLT/beauty-1.png",
    title: "Blue Rescue Face Mask",
    slug: "blue-rescue-face-mask",
    unit: "150ml",
    imageURLs: [
      {
        color: {
          name: "Flame",
          clrCode: "#D74E27",
        },
        img: "https://i.ibb.co/XsZ9vLT/beauty-1.png",
      },
      {
        color: {
          name: "Flame",
          clrCode: "#D74E27",
        },
        img: "https://i.ibb.co/9qnGsJq/beauty-2.png",
      },
      {
        color: {
          name: "Flame",
          clrCode: "#D74E27",
        },
        img: "https://i.ibb.co/1JWCCnS/beauty-3.png",
      },
    ],
    parent: "Facial Care",
    children: "Powder",
    price: 72,
    discount: 5,
    quantity: 15,
    brand: {
      name: "INIKA",
    },
    category: {
      name: "Facial Care",
    },
    status: "in-stock",
    reviews: [],
    productType: "beauty",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "Colors",
        value: "Wine Berry , Dirty Blue",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
      {
        key: "FEMIMINE HEMLINE",
        value: "Fashionable curved hem",
      },
      {
        key: "Graphics Coprocessor",
        value: "Exynos 9611, Octa Core (4x2.3GHz + 4x1.7GHz)",
      },
      {
        key: "Wireless Type",
        value: "802.11a/b/g/n/ac, Bluetooth",
      },
    ],
    tags: ["facial care", "powder"],
    featured: false,
    sellCount: 0,
  },
  {
    id: "6431364df5a812bd37e765ac",
    sku: "AEB7SDVX70",
    img: "https://i.ibb.co/J7C8xSR/bracelet-1.png",
    title: "Robert Lee Bangle Bracelet",
    slug: "robert-lee-bangle-bracelet",
    unit: "18 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/J7C8xSR/bracelet-1.png",
      },
      {
        img: "https://i.ibb.co/8g1W4Pp/bracelet-2.png",
      },
      {
        img: "https://i.ibb.co/2W3S5Xc/bracelet-3.png",
      },
    ],
    parent: "Bracelets",
    children: "Gold",
    price: 250,
    discount: 3,
    quantity: 15,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Bracelets",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["bracelets", "gold"],
    featured: true,
    sellCount: 0,
    sizes: [],
  },
  {
    id: "64313abdf5a812bd37e765bc",
    sku: "ABC7SDVX70",
    img: "https://i.ibb.co/s2gB5tt/earring-1.png",
    title: "Fortuna Creole Earring",
    slug: "fortuna-creole-earring",
    unit: "18 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/s2gB5tt/earring-1.png",
      },
      {
        img: "https://i.ibb.co/4TTyyZ2/earring-2.png",
      },
      {
        img: "https://i.ibb.co/k0x8r9r/earring-3.png",
      },
    ],
    parent: "Earrings",
    children: "Gold",
    price: 180,
    discount: 0,
    quantity: 10,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Earrings",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["earrings", "gold"],
    featured: true,
    sellCount: 0,
  },
  {
    id: "64313e92f5a812bd37e765cf",
    sku: "ADC7SDVX70",
    img: "https://i.ibb.co/KsZ69S3/necklaces-1.png",
    title: "asiyah necklace",
    slug: "asiyah-necklace",
    unit: "15 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/KsZ69S3/necklaces-1.png",
      },
      {
        img: "https://i.ibb.co/WPMYcmL/necklaces-2.png",
      },
      {
        img: "https://i.ibb.co/kBB1p6F/necklaces-3.png",
      },
    ],
    parent: "Necklaces",
    children: "Gold",
    price: 200,
    discount: 2,
    quantity: 8,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Necklaces",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["necklaces", "gold"],
    featured: true,
    sellCount: 0,
    sizes: [],
  },
  {
    id: "6431418c5e1d915c39ada44b",
    sku: "AEC7SDVX70",
    img: "https://i.ibb.co/nnxXBTh/bracelet-4.png",
    title: "Fortuna Bangle Three-row",
    slug: "fortuna-bangle-three-row",
    unit: "14 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/nnxXBTh/bracelet-4.png",
      },
      {
        img: "https://i.ibb.co/rvmPWxc/bracelet-5.png",
      },
      {
        img: "https://i.ibb.co/VqGrnz9/bracelet-6.png",
      },
      {
        img: "https://i.ibb.co/CKkRNnQ/bracelet-7.png",
      },
    ],
    parent: "Bracelets",
    children: "Silver",
    price: 110,
    discount: 0,
    quantity: 18,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Bracelets",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["bracelets", "silver"],
    featured: true,
    sellCount: 0,
  },
  {
    id: "64323fd99814bb139594c443",
    sku: "BAC7SDVX70",
    img: "https://i.ibb.co/s12Fy6m/earring-4.png",
    title: "Palm Ring",
    slug: "palm-ring",
    unit: "18 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/s12Fy6m/earring-4.png",
      },
      {
        img: "https://i.ibb.co/7rL5bgs/earring-5.png",
      },
      {
        img: "https://i.ibb.co/p2BCQrp/earring-6.png",
      },
      {
        img: "https://i.ibb.co/JBnqqJH/earring-7.png",
      },
    ],
    parent: "Earrings",
    children: "Silver",
    price: 135,
    discount: 0,
    quantity: 13,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Earrings",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["earrings", "silver"],
    featured: true,
    sellCount: 3,
  },
  {
    id: "6432433c9814bb139594c44c",
    sku: "BCC7SDVX54",
    img: "https://i.ibb.co/cwzhf2G/necklaces-4.png",
    title: "Birthstone Necklace for Women",
    slug: "birthstone-necklace-for-women",
    unit: "14 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/cwzhf2G/necklaces-4.png",
      },
      {
        img: "https://i.ibb.co/fCMG4Fb/necklaces-5.png",
      },
      {
        img: "https://i.ibb.co/FDB60xJ/necklaces-6.png",
      },
    ],
    parent: "Necklaces",
    children: "Silver",
    price: 100,
    discount: 3,
    quantity: 13,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Necklaces",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["necklaces", "silver"],
    featured: false,
    sellCount: 0,
  },
  {
    id: "643249b49814bb139594c454",
    sku: "BAD7SDVX55",
    img: "https://i.ibb.co/SvdvsxT/bracelet-8.png",
    title: "Asiyah Bangle Bracelet",
    slug: "asiyah-bangle-bracelet",
    unit: "10 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/SvdvsxT/bracelet-8.png",
      },
      {
        img: "https://i.ibb.co/nRtHQf5/bracelet-9.png",
      },
      {
        img: "https://i.ibb.co/1LJ7nnR/bracelet-10.png",
      },
    ],
    parent: "Bracelets",
    children: "Silver",
    price: 118,
    discount: 0,
    quantity: 15,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Bracelets",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["bracelets", "silver"],
    featured: true,
    sellCount: 0,
  },
  {
    id: "64324f0c9814bb139594c47c",
    sku: "BDC7SDVX88",
    img: "https://i.ibb.co/Bf0gXqY/earring-8.png",
    title: "Fortuna Creole Hoop",
    slug: "fortuna-creole-hoop",
    unit: "12 kt",
    imageURLs: [
      {
        img: "https://i.ibb.co/Bf0gXqY/earring-8.png",
      },
      {
        img: "https://i.ibb.co/FX5VyWP/earring-9.png",
      },
      {
        img: "https://i.ibb.co/zQzsWqW/earring-10.png",
      },
    ],
    parent: "Earrings",
    children: "Silver",
    price: 99,
    discount: 0,
    quantity: 9,
    brand: {
      name: "Louis Vuitton",
    },
    category: {
      name: "Earrings",
    },
    status: "in-stock",
    reviews: [],
    productType: "jewelry",
    description:
      "Achieve that sun-kissed glow with the Baked Mineral Bronzer from INIKA. Perfect for contouring, the loose powder adds a subtle and natural tanned tone to skin, perfectly complementing fair to medium complexions. Lightweight and non-cakey, it effortlessly sculpts and defines cheekbones to leave skin looking healthy and radiant. Certified Vegan. Cruelty free.",
    additionalInformation: [
      {
        key: "GREAT FOR LAYERING",
        value: "Mini waffle fabric construction",
      },
      {
        key: "LEGENDARY STYLING",
        value: "Cute keyhole notch neck with custom",
      },
      {
        key: "CUFF DETAILS",
        value: "Velvet details with lace trim on the cuffs",
      },
    ],
    tags: ["earrings", "silver"],
    featured: true,
    sellCount: 2,
  },
];

export default product_data;
